Ext.data.JsonP.sol_common_ix_services_GetRedactorTemplates({"tagname":"class","name":"sol.common.ix.services.GetRedactorTemplates","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"sol.common.ix.services.GetRedactorTemplates.js","href":"sol.common.ix.services.GetRedactorTemplates.html#sol-common-ix-services-GetRedactorTemplates"}],"author":[{"tagname":"author","name":"ESt, ELO Digital Office GmbH","email":null}],"eloix":true,"requires":["sol.common.Config","sol.common.IxUtils","sol.common.JsonUtils","sol.common.UserUtils","sol.common.ix.RfUtils","sol.common.ix.ServiceBase"],"aliases":{},"alternateClassNames":[],"extends":"sol.common.ix.ServiceBase","mixins":[],"uses":[],"members":[{"name":"load","tagname":"cfg","owner":"sol.common.ix.services.GetRedactorTemplates","id":"cfg-load","meta":{}},{"name":"objId","tagname":"cfg","owner":"sol.common.ix.ServiceBase","id":"cfg-objId","meta":{}},{"name":"render","tagname":"cfg","owner":"sol.common.ix.services.GetRedactorTemplates","id":"cfg-render","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"templates","tagname":"cfg","owner":"sol.common.ix.services.GetRedactorTemplates","id":"cfg-templates","meta":{}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"data","tagname":"property","owner":"sol.common.ix.ServiceBase","id":"property-data","meta":{}},{"name":"doublesAsSord","tagname":"property","owner":"sol.common.ix.services.GetRedactorTemplates","id":"property-doublesAsSord","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.common.ix.ServiceBase","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"checkMandatoryProperties","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-checkMandatoryProperties","meta":{"protected":true}},{"name":"collectDataFromIds","tagname":"method","owner":"sol.common.ix.services.GetRedactorTemplates","id":"method-collectDataFromIds","meta":{"private":true}},{"name":"collectSordData","tagname":"method","owner":"sol.common.ix.services.GetRedactorTemplates","id":"method-collectSordData","meta":{"private":true}},{"name":"collectTemplatingData","tagname":"method","owner":"sol.common.ix.services.GetRedactorTemplates","id":"method-collectTemplatingData","meta":{"private":true}},{"name":"containsClassName","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-containsClassName","meta":{}},{"name":"getConfigProp","tagname":"method","owner":"sol.common.ix.services.GetRedactorTemplates","id":"method-getConfigProp","meta":{"private":true}},{"name":"getPredefinedData","tagname":"method","owner":"sol.common.ix.services.GetRedactorTemplates","id":"method-getPredefinedData","meta":{"private":true}},{"name":"getRawTemplates","tagname":"method","owner":"sol.common.ix.services.GetRedactorTemplates","id":"method-getRawTemplates","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-initialize","meta":{"private":true}},{"name":"isValidConfigDef","tagname":"method","owner":"sol.common.ix.services.GetRedactorTemplates","id":"method-isValidConfigDef","meta":{"private":true}},{"name":"isValidEntitiesDef","tagname":"method","owner":"sol.common.ix.services.GetRedactorTemplates","id":"method-isValidEntitiesDef","meta":{"private":true}},{"name":"merge","tagname":"method","owner":"sol.common.ix.services.GetRedactorTemplates","id":"method-merge","meta":{"private":true}},{"name":"prefillMetadata","tagname":"method","owner":"sol.common.ix.ServiceBase","id":"method-prefillMetadata","meta":{"protected":true}},{"name":"process","tagname":"method","owner":"sol.common.ix.services.GetRedactorTemplates","id":"method-process","meta":{}},{"name":"renderAny","tagname":"method","owner":"sol.common.ix.services.GetRedactorTemplates","id":"method-renderAny","meta":{"private":true}},{"name":"renderTemplates","tagname":"method","owner":"sol.common.ix.services.GetRedactorTemplates","id":"method-renderTemplates","meta":{"private":true}},{"name":"search","tagname":"method","owner":"sol.common.ix.services.GetRedactorTemplates","id":"method-search","meta":{"private":true}},{"name":"searchAndIncludeSords","tagname":"method","owner":"sol.common.ix.services.GetRedactorTemplates","id":"method-searchAndIncludeSords","meta":{"private":true}},{"name":"searchForEntity","tagname":"method","owner":"sol.common.ix.services.GetRedactorTemplates","id":"method-searchForEntity","meta":{"private":true}},{"name":"shouldRenderEverything","tagname":"method","owner":"sol.common.ix.services.GetRedactorTemplates","id":"method-shouldRenderEverything","meta":{"private":true}},{"name":"shouldSearchForAdditionalData","tagname":"method","owner":"sol.common.ix.services.GetRedactorTemplates","id":"method-shouldSearchForAdditionalData","meta":{"private":true}},{"name":"withRenderedDesc","tagname":"method","owner":"sol.common.ix.services.GetRedactorTemplates","id":"method-withRenderedDesc","meta":{"private":true}},{"name":"RF_sol_common_service_GetRedactorTemplates","tagname":"method","owner":"sol.common.ix.services.GetRedactorTemplates","id":"static-method-RF_sol_common_service_GetRedactorTemplates","meta":{"static":true}}],"code_type":"ext_define","id":"class-sol.common.ix.services.GetRedactorTemplates","short_doc":"Retrieves templates (clips) for a redactor\n\nFor an implementation using this service, please see sol.recruiting.ix.se...","classIcon":"icon-class","superclasses":["sol.Base","sol.common.ix.ServiceBase"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='docClass'>sol.common.ix.ServiceBase</a><div class='subclass '><strong>sol.common.ix.services.GetRedactorTemplates</strong></div></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.Config' rel='sol.common.Config' class='docClass'>sol.common.Config</a></div><div class='dependency'><a href='#!/api/sol.common.IxUtils' rel='sol.common.IxUtils' class='docClass'>sol.common.IxUtils</a></div><div class='dependency'><a href='#!/api/sol.common.JsonUtils' rel='sol.common.JsonUtils' class='docClass'>sol.common.JsonUtils</a></div><div class='dependency'><a href='#!/api/sol.common.UserUtils' rel='sol.common.UserUtils' class='docClass'>sol.common.UserUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ix.RfUtils' rel='sol.common.ix.RfUtils' class='docClass'>sol.common.ix.RfUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='docClass'>sol.common.ix.ServiceBase</a></div><h4>Files</h4><div class='dependency'><a href='source/sol.common.ix.services.GetRedactorTemplates.html#sol-common-ix-services-GetRedactorTemplates' target='_blank'>sol.common.ix.services.GetRedactorTemplates.js</a></div></pre><div class='doc-contents'><p>Retrieves templates (clips) for a redactor</p>\n\n<p>For an implementation using this service, please see sol.recruiting.ix.services.GetCommunicationRedactorTemplates.</p>\n\n<h3>Get Redactor Templates. Use data from sords in templating.</h3>\n\n<pre><code>{\n  templates: [\n    { desc: \"{{translate 'sol.recruiting.form.candidate.no'}}\", value: \"{{CANDIDATE.objKeys.RECRUITING_CANDIDATE_NO}}\" },\n    { desc: \"{{translate 'sol.recruiting.form.candidate.firstname'}}\", value: \"{{CANDIDATE.objKeys.RECRUITING_CANDIDATE_FIRSTNAME}}\" },\n    { desc: \"{{translate 'sol.recruiting.form.candidate.lastname'}}\", value: \"{{REQUISITION.objKeys.RECRUITING_REQUISITION_NAME}}\" },\n    { desc: \"{{translate 'sol.recruiting.form.candidate.privatephone'}}\", value: \"{{CANDIDATE.mapKeys.RECRUITING_CANDIDATE_PRIVATEPHONE}}\" }\n  ],\n  render: {\n    searchAdditionalData: [\n      {\n        targetProp: \"REQUISITION\",\n        criteria: [\n          { key: \"RECRUITING_REQUISITION_NO\", value: \"R12345\" },\n          { key: \"SOL_TYPE\", value: [\"RECRUITING_REQUISITION\", \"RECRUITING_POOL\"] }\n        ]\n      },\n      {\n        targetProp: \"CANDIDATE\",\n        doubleAsSord: true,\n        masks: [\"Recruiting Candidate\"],\n        criteria: [\n          { key: \"RECRUITING_CANDIDATE_NO\", value: \"C44312\" },\n          { key: \"SOL_TYPE\", value: \"RECRUITING_CANDIDATE\" }\n        ]\n      }\n    ]\n  }\n}\n</code></pre>\n\n<p>We want 4 redactor templates to be available. Since they require templating data from a requisition and a candidate, we\ndefine a search, which will find both and make their data available to handlebars.</p>\n\n<p>Since it is common to make a specific sord available as the <code>sord</code> property in handlebars, we use CANDIDATE as <code>sord</code> by defining <code>doubleAsSord</code>.</p>\n\n<p>This means, <code>sord.objKeys.RECRUITING_CANDIDATE_NO</code> === <code>CANDIDATE.objKeys.RECRUITING_CANDIDATE_NO</code>.</p>\n\n<p>Instead of supplying a <code>criteria</code> and optionally a <code>mask/masks</code> property, you can also define a <code>id</code> or <code>guid</code> property, if you already know, which\nsords to use for templating.</p>\n\n<pre><code>{\n  targetProp: \"CANDIDATE\",\n  doubleAsSord: true,\n  id: \"44292\"\n}\n</code></pre>\n\n<h4>Result</h4>\n\n<pre><code>{\n  templates: [\n    [\"Bewerbernummer\", \"0001\"],\n    [\"Bezeichnung\", \"Initiativbewerbungen\"],\n    [\"Telefon\", \"001211439123\"]\n    [\"Vorname\", \"Test\"]\n  ]\n}\n</code></pre>\n\n<h3>Only render description text</h3>\n\n<p>Any templating strings in the value part of the template definition will not be altered with this setting:</p>\n\n<pre><code>render: {\n  onlyDescription: true\n}\n</code></pre>\n\n<h4>Result</h4>\n\n<pre><code>{\n  templates: [\n    [\"Bewerbernummer\", \"{{CANDIDATE.objKeys.RECRUITING_CANDIDATE_NO}}\"],\n    [\"Bezeichnung\", \"{{REQUISITION.objKeys.RECRUITING_REQUISITION_NAME}}\"],\n    [\"Telefon\", \"{{CANDIDATE.mapKeys.RECRUITING_CANDIDATE_PRIVATEPHONE}}\"]\n    [\"Vorname\", \"{{CANDIDATE.objKeys.RECRUITING_CANDIDATE_FIRSTNAME}}\"]\n  ]\n}\n</code></pre>\n\n<h3>Loading templates from a configuration</h3>\n\n<p>This service will most often be called from a workflow from or webapp.</p>\n\n<p>The <code>load</code> parameter enables loading the <code>templates</code> from a configuration instead of defining them in the call.</p>\n\n<pre><code>{\n  load: {\n    config: \"/recruiting/Configuration/recruiting.config\",\n    jsonPath: \"entities.myredactor.mytemplates\"\n  }\n}\n</code></pre>\n\n<h3>Details on Results</h3>\n\n<p>Only descriptions having a value after templating will be added to the results.</p>\n\n<p>If the value of a template has no value after templating, itself and its description will not be added to the results.</p>\n\n<p>Results are ordered alphabetically by description.</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-load' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetRedactorTemplates'>sol.common.ix.services.GetRedactorTemplates</span><br/><a href='source/sol.common.ix.services.GetRedactorTemplates.html#sol-common-ix-services-GetRedactorTemplates-cfg-load' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetRedactorTemplates-cfg-load' class='name expandable'>load</a> : Object[]<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional if templates is defined) ...</div><div class='long'><p>(optional if <code>templates</code> is defined)</p>\n<ul><li><span class='pre'>Object</span> : Object<div class='sub-desc'>\n<ul><li><span class='pre'>config</span> : String<div class='sub-desc'><p>path to config (e.g. /recruiting/Configuration/recruiting.config)</p>\n</div></li><li><span class='pre'>jsonPath</span> : String<div class='sub-desc'><p>json path to property in config containing the templates</p>\n</div></li></ul></div></li></ul></div></div></div><div id='cfg-objId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-cfg-objId' class='name expandable'>objId</a> : string<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Object ID for the element</p>\n</div><div class='long'><p>Object ID for the element</p>\n</div></div></div><div id='cfg-render' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetRedactorTemplates'>sol.common.ix.services.GetRedactorTemplates</span><br/><a href='source/sol.common.ix.services.GetRedactorTemplates.html#sol-common-ix-services-GetRedactorTemplates-cfg-render' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetRedactorTemplates-cfg-render' class='name expandable'>render</a> : Object[]<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) ...</div><div class='long'><p>(optional)</p>\n<ul><li><span class='pre'>onlyDesc</span> : Boolean (optional)<div class='sub-desc'><p>(optional) only renders the description while leaving the value unchanged</p>\n<p>Defaults to: <code>false</code></p></div></li><li><span class='pre'>data</span> : Object<div class='sub-desc'><p>(optional) data for templating</p>\n</div></li><li><span class='pre'>searchAdditionalData</span> : Object[]<div class='sub-desc'><p>(optional) add sords to templating data</p>\n<ul><li><span class='pre'>Object</span> : Object<div class='sub-desc'>\n<ul><li><span class='pre'>targetProp</span> : String<div class='sub-desc'><p>sord's target name in templating</p>\n</div></li><li><span class='pre'>doubleAsSord</span> : Boolean<div class='sub-desc'><p>this sord will also be available as <code>sord</code></p>\n</div></li><li><span class='pre'>id</span> : String|String[]<div class='sub-desc'><p>(optional) sord's objId</p>\n</div></li><li><span class='pre'>guid</span> : String|String[]<div class='sub-desc'><p>(optional) sord's guid</p>\n</div></li><li><span class='pre'>masks</span> : String|String[]<div class='sub-desc'><p>(optional) masks to include in search</p>\n</div></li><li><span class='pre'>criteria</span> : Object[]<div class='sub-desc'><p>(optional) search criteria</p>\n</div></li></ul></div></li></ul></div></li></ul></div></div></div><div id='cfg-requiredConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div><div id='cfg-templates' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetRedactorTemplates'>sol.common.ix.services.GetRedactorTemplates</span><br/><a href='source/sol.common.ix.services.GetRedactorTemplates.html#sol-common-ix-services-GetRedactorTemplates-cfg-templates' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetRedactorTemplates-cfg-templates' class='name expandable'>templates</a> : Object[]<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional if load is defined) ...</div><div class='long'><p>(optional if <code>load</code> is defined)</p>\n<ul><li><span class='pre'>Object</span> : Object<div class='sub-desc'>\n<ul><li><span class='pre'>desc</span> : String<div class='sub-desc'><p>description of the template (selectable in redactor clips)</p>\n</div></li><li><span class='pre'>value</span> : String<div class='sub-desc'><p>value of the redactor template. Will be inserted if redactor clip is clicked.</p>\n</div></li></ul></div></li></ul></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-data' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-property-data' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-property-data' class='name expandable'>data</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'><p>(optional)\nHas to be in a specific form (see <a href=\"#!/api/sol.common.SordUtils-method-updateSord\" rel=\"sol.common.SordUtils-method-updateSord\" class=\"docClass\">sol.common.SordUtils.updateSord</a>).</p>\n</div><div class='long'><p>(optional)\nHas to be in a specific form (see <a href=\"#!/api/sol.common.SordUtils-method-updateSord\" rel=\"sol.common.SordUtils-method-updateSord\" class=\"docClass\">sol.common.SordUtils.updateSord</a>).</p>\n</div></div></div><div id='property-doublesAsSord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetRedactorTemplates'>sol.common.ix.services.GetRedactorTemplates</span><br/><a href='source/sol.common.ix.services.GetRedactorTemplates.html#sol-common-ix-services-GetRedactorTemplates-property-doublesAsSord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetRedactorTemplates-property-doublesAsSord' class='name expandable'>doublesAsSord</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>enables optimization. ...</div><div class='long'><p>enables optimization. Will store optimization cache ID</p>\n<p>Defaults to: <code>&quot;&quot;</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>The logger for the service</p>\n</div><div class='long'><p>The logger for the service</p>\n<p>Overrides: <a href=\"#!/api/sol.Base-property-logger\" rel=\"sol.Base-property-logger\" class=\"docClass\">sol.Base.logger</a></p></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance methods</h3><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-checkMandatoryProperties' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-checkMandatoryProperties' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-checkMandatoryProperties' class='name expandable'>checkMandatoryProperties</a>( <span class='pre'></span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Checks if all mandatory properties have been set. ...</div><div class='long'><p>Checks if all mandatory properties have been set.</p>\n</div></div></div><div id='method-collectDataFromIds' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetRedactorTemplates'>sol.common.ix.services.GetRedactorTemplates</span><br/><a href='source/sol.common.ix.services.GetRedactorTemplates.html#sol-common-ix-services-GetRedactorTemplates-method-collectDataFromIds' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetRedactorTemplates-method-collectDataFromIds' class='name expandable'>collectDataFromIds</a>( <span class='pre'>entities, entityIds</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>entities</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>entityIds</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-collectSordData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetRedactorTemplates'>sol.common.ix.services.GetRedactorTemplates</span><br/><a href='source/sol.common.ix.services.GetRedactorTemplates.html#sol-common-ix-services-GetRedactorTemplates-method-collectSordData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetRedactorTemplates-method-collectSordData' class='name expandable'>collectSordData</a>( <span class='pre'>entity, id</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>entity</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>id</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-collectTemplatingData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetRedactorTemplates'>sol.common.ix.services.GetRedactorTemplates</span><br/><a href='source/sol.common.ix.services.GetRedactorTemplates.html#sol-common-ix-services-GetRedactorTemplates-method-collectTemplatingData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetRedactorTemplates-method-collectTemplatingData' class='name expandable'>collectTemplatingData</a>( <span class='pre'>renderOpts</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>renderOpts</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-containsClassName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-containsClassName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-containsClassName' class='name expandable'>containsClassName</a>( <span class='pre'>classNames</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks wether an array contains the class name ...</div><div class='long'><p>Checks wether an array contains the class name</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>classNames</span> : Array<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getConfigProp' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetRedactorTemplates'>sol.common.ix.services.GetRedactorTemplates</span><br/><a href='source/sol.common.ix.services.GetRedactorTemplates.html#sol-common-ix-services-GetRedactorTemplates-method-getConfigProp' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetRedactorTemplates-method-getConfigProp' class='name expandable'>getConfigProp</a>( <span class='pre'>config, path</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>will contain targetProp of sord whose config property dobuleAsSord is true ...</div><div class='long'><p>will contain targetProp of sord whose config property <code>dobuleAsSord</code> is true</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>path</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getPredefinedData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetRedactorTemplates'>sol.common.ix.services.GetRedactorTemplates</span><br/><a href='source/sol.common.ix.services.GetRedactorTemplates.html#sol-common-ix-services-GetRedactorTemplates-method-getPredefinedData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetRedactorTemplates-method-getPredefinedData' class='name expandable'>getPredefinedData</a>( <span class='pre'>renderOpts</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>renderOpts</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getRawTemplates' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetRedactorTemplates'>sol.common.ix.services.GetRedactorTemplates</span><br/><a href='source/sol.common.ix.services.GetRedactorTemplates.html#sol-common-ix-services-GetRedactorTemplates-method-getRawTemplates' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetRedactorTemplates-method-getRawTemplates' class='name expandable'>getRawTemplates</a>( <span class='pre'>templates, load</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>templates</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>load</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a></p></div></div></div><div id='method-isValidConfigDef' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetRedactorTemplates'>sol.common.ix.services.GetRedactorTemplates</span><br/><a href='source/sol.common.ix.services.GetRedactorTemplates.html#sol-common-ix-services-GetRedactorTemplates-method-isValidConfigDef' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetRedactorTemplates-method-isValidConfigDef' class='name expandable'>isValidConfigDef</a>( <span class='pre'>def</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>def</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-isValidEntitiesDef' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetRedactorTemplates'>sol.common.ix.services.GetRedactorTemplates</span><br/><a href='source/sol.common.ix.services.GetRedactorTemplates.html#sol-common-ix-services-GetRedactorTemplates-method-isValidEntitiesDef' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetRedactorTemplates-method-isValidEntitiesDef' class='name expandable'>isValidEntitiesDef</a>( <span class='pre'>entities</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>entities</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-merge' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetRedactorTemplates'>sol.common.ix.services.GetRedactorTemplates</span><br/><a href='source/sol.common.ix.services.GetRedactorTemplates.html#sol-common-ix-services-GetRedactorTemplates-method-merge' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetRedactorTemplates-method-merge' class='name expandable'>merge</a>( <span class='pre'>tData, results</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tData</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>results</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-prefillMetadata' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.ServiceBase' rel='sol.common.ix.ServiceBase' class='defined-in docClass'>sol.common.ix.ServiceBase</a><br/><a href='source/lib_sol.common.ix.ServiceBase.html#sol-common-ix-ServiceBase-method-prefillMetadata' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.ServiceBase-method-prefillMetadata' class='name expandable'>prefillMetadata</a>( <span class='pre'>objId</span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Initializes the metadata of an element (defined by objId) from the internal data object. ...</div><div class='long'><p>Initializes the metadata of an element (defined by <code>objId</code>) from the internal <code>data</code> object.</p>\n\n<p>The <code>data</code> property has to be in a specific <a href=\"#!/api/sol.common.ix.ServiceBase-property-data\" rel=\"sol.common.ix.ServiceBase-property-data\" class=\"docClass\">form</a>.\nIf there is no data object no prefilling will be performed.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-process' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetRedactorTemplates'>sol.common.ix.services.GetRedactorTemplates</span><br/><a href='source/sol.common.ix.services.GetRedactorTemplates.html#sol-common-ix-services-GetRedactorTemplates-method-process' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetRedactorTemplates-method-process' class='name expandable'>process</a>( <span class='pre'></span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>return</p>\n<ul><li><span class='pre'>templates</span> : String[][]<div class='sub-desc'><p>an array of all templates (each template is an array of [0] description and [1] value)</p>\n</div></li></ul></div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.ServiceBase-method-process\" rel=\"sol.common.ix.ServiceBase-method-process\" class=\"docClass\">sol.common.ix.ServiceBase.process</a></p></div></div></div><div id='method-renderAny' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetRedactorTemplates'>sol.common.ix.services.GetRedactorTemplates</span><br/><a href='source/sol.common.ix.services.GetRedactorTemplates.html#sol-common-ix-services-GetRedactorTemplates-method-renderAny' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetRedactorTemplates-method-renderAny' class='name expandable'>renderAny</a>( <span class='pre'>obj, tData</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>obj</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>tData</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-renderTemplates' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetRedactorTemplates'>sol.common.ix.services.GetRedactorTemplates</span><br/><a href='source/sol.common.ix.services.GetRedactorTemplates.html#sol-common-ix-services-GetRedactorTemplates-method-renderTemplates' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetRedactorTemplates-method-renderTemplates' class='name expandable'>renderTemplates</a>( <span class='pre'>configProp, tData, renderEverything</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>configProp</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>tData</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>renderEverything</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-search' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetRedactorTemplates'>sol.common.ix.services.GetRedactorTemplates</span><br/><a href='source/sol.common.ix.services.GetRedactorTemplates.html#sol-common-ix-services-GetRedactorTemplates-method-search' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetRedactorTemplates-method-search' class='name expandable'>search</a>( <span class='pre'>entities</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>entities</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-searchAndIncludeSords' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetRedactorTemplates'>sol.common.ix.services.GetRedactorTemplates</span><br/><a href='source/sol.common.ix.services.GetRedactorTemplates.html#sol-common-ix-services-GetRedactorTemplates-method-searchAndIncludeSords' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetRedactorTemplates-method-searchAndIncludeSords' class='name expandable'>searchAndIncludeSords</a>( <span class='pre'>tData, entities</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tData</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>entities</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-searchForEntity' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetRedactorTemplates'>sol.common.ix.services.GetRedactorTemplates</span><br/><a href='source/sol.common.ix.services.GetRedactorTemplates.html#sol-common-ix-services-GetRedactorTemplates-method-searchForEntity' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetRedactorTemplates-method-searchForEntity' class='name expandable'>searchForEntity</a>( <span class='pre'>entity</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>entity</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-shouldRenderEverything' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetRedactorTemplates'>sol.common.ix.services.GetRedactorTemplates</span><br/><a href='source/sol.common.ix.services.GetRedactorTemplates.html#sol-common-ix-services-GetRedactorTemplates-method-shouldRenderEverything' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetRedactorTemplates-method-shouldRenderEverything' class='name expandable'>shouldRenderEverything</a>( <span class='pre'>renderOpts</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>renderOpts</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-shouldSearchForAdditionalData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetRedactorTemplates'>sol.common.ix.services.GetRedactorTemplates</span><br/><a href='source/sol.common.ix.services.GetRedactorTemplates.html#sol-common-ix-services-GetRedactorTemplates-method-shouldSearchForAdditionalData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetRedactorTemplates-method-shouldSearchForAdditionalData' class='name expandable'>shouldSearchForAdditionalData</a>( <span class='pre'>renderOpts</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>renderOpts</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-withRenderedDesc' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetRedactorTemplates'>sol.common.ix.services.GetRedactorTemplates</span><br/><a href='source/sol.common.ix.services.GetRedactorTemplates.html#sol-common-ix-services-GetRedactorTemplates-method-withRenderedDesc' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetRedactorTemplates-method-withRenderedDesc' class='name expandable'>withRenderedDesc</a>( <span class='pre'>tData, o</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tData</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>o</span> : Object<div class='sub-desc'></div></li></ul></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static methods</h3><div id='static-method-RF_sol_common_service_GetRedactorTemplates' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetRedactorTemplates'>sol.common.ix.services.GetRedactorTemplates</span><br/><a href='source/sol.common.ix.services.GetRedactorTemplates.html#sol-common-ix-services-GetRedactorTemplates-static-method-RF_sol_common_service_GetRedactorTemplates' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetRedactorTemplates-static-method-RF_sol_common_service_GetRedactorTemplates' class='name expandable'>RF_sol_common_service_GetRedactorTemplates</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\ns...</div><div class='long'><p>This service can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_ServiceBaseName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloix":true}});